#include <bits/stdc++.h>
using namespace std;
#define all(x) (x).begin(), (x).end()
#define pb push_back
#define mp make_pair
#define lb lower_bound
#define ub upper_bound
#define in(n) int n = nxt()
inline int nxt() {
    int n;
    scanf("%d", &n);
    return n;
}
typedef long long ll;
typedef long double ld;
typedef pair<int, int> PII;
typedef pair<ll, ll> PLL;

struct pt {
    int x, y;
    pt(const int &x = 0, const int &y = 0) : x(x), y(y) {}
    pt(const pt &r) : x(r.x), y(r.y) {}
    pt & operator = (const pt &r) {
        if (this == &r) {
            return *this;
        }
        x = r.x;
        y = r.y;
        return *this;
    }

    pt operator + (const pt &r) const {
        return pt(x + r.x, y + r.y);
    }

    pt operator - (const pt &r) const {
        return pt(x - r.x, y - r.y);
    }

    friend int scal(const pt &l, const pt &r) {
        return l.x * r.x + l.y * r.y;
    }
    friend int vect(const pt &l, const pt &r) {
        return l.x * r.y - l.y * r.x;
    }
};

vector<vector<int> > g;


inline bool check(const pt &a, const pt &b, const pt &c, const pt &d) {
    if (vect(a - b, c - d) != 0) {
        return false;
    }
    if (vect(a - b, c - b) != 0) {
        return false;
    }
    int tb = 0;
    int ta = scal(a - b, a - b);
    int tc = scal(a - b, c - b);
    int td = scal(a - b, d - b);
    if (tc > td) {
        swap(tc, td);
    }
    int l = max(tb, tc);
    int r = min(ta, td);
    return l < r;
}

inline bool check(const vector<pt> &a, const vector<pt> &b) {
    int n = a.size();
    int m = b.size();
    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < m; ++j) {
            if (check(a[i], a[(i + 1) % n], b[j], b[(j + 1) % m])) {
                return true;
            }
        }
    }
    return false;
}

const int N = 40;
char part[N];
int q[N];
char used[2 * N];
int sz = 0;
int order[2 * N];
int color[2 * N];
vector<int> G[2 * N];
vector<int> GT[2 * N];

void dfs(int v) {
    used[v] = 1;
    for (int to : G[v]) {
        if (!used[to]) {
            dfs(to);
        }
    }
    order[sz++] = (v);
}

void dfs2(int v, int c) {
    color[v] = c;
    for (int to : GT[v]) {
        if (color[to] == -1) {
            dfs2(to, c);
        }
    }
}

inline bool check2() {
    int n = g.size();
    memset(part, 255, n * sizeof(char));
    bool ok = true;
    for (int st = 0; st < n; ++st) {
        if (used[st]) {
            continue;
        }
        if (part[st] == -1) {
            int h = 0, t = 0;
            q[t++] = st;
            part[st] = 0;
            while (h<t) {
                int v = q[h++];
                for (int to : g[v]) {
                    if (used[to]) {
                        continue;
                    }
                    if (part[to] == -1)
                        part[to] = !part[v],  q[t++] = to;
                    else {
                        ok &= part[to] != part[v];
                        if (!ok) {
                            return false;
                        }
                    }
                }
            }
        }
    }
    return ok;
}

//bool rec(int u = 0, int cnt = 0) {
//    int v = order[u];
//    if (u == g.size()) {
//        return check2();
//    }
//    if (cnt + 1 > g.size() / 3) {
//        return check2();
//    }

//    ++it;
//    if (it >= IT) {
//        return false;
//    }
//    bool ok = true;
//    for (int to : g[v]) {
//        if (used[to]) {
//            ok = false;
//            break;
//        }
//    }

//    if (ok) {
//        used[v] = 1;
//        if (rec(u + 1, cnt + 1)) {
//            return true;
//        }
//        used[v] = 0;
//    }

//    if (rec(u + 1, cnt)) {
//        return true;
//    }
//}

int nn;

inline bool checkSAT() {
    sz = 0;
    memset(used, 0, nn);
    memset(color, 255, nn * sizeof(int));
    for (int i = 0; i < nn; ++i) {
        if (!used[i]) {
            dfs(i);
        }
    }
    reverse(order, order + sz);
    int c = 0;
    for (int i = 0; i < nn; ++i) {
        int v = order[i];
        if (color[v] == -1) {
            dfs2(v, c++);
        }
    }
    for (int i = 0; i < nn; ++i) {
        if (color[i] == color[i ^ 1]) {
            return false;
        }
    }
    return true;
}

bool check3() {
    int n = g.size();
    int IT = min(50000.0, pow(1.5, n));
    nn = 2 * n;
    PII col[n];
    while (IT--) {
        for (int i = 0; i < n; ++i) {
            int q = rand() % 3;
            col[i].first = q;
            col[i].second = (q + 1) % 3;
            G[i + i].clear();G[i + i + 1].clear();
            GT[i + i].clear();GT[i + i + 1].clear();
        }

        for (int i = 0; i < n; ++i) {
            for (int to : g[i]) {
                if (col[i].first == col[to].first) {
                    G[i + i].push_back(to + to + 1);
                    GT[to + to + 1].push_back(i + i);
                }
                if (col[i].first == col[to].second) {
                    G[i + i].push_back(to + to);
                    GT[to + to].push_back(i + i);
                }

                if (col[i].second == col[to].first) {
                    G[i + i + 1].push_back(to + to + 1);
                    GT[to + to + 1].push_back(i + i + 1);
                }
                if (col[i].second == col[to].second) {
                    G[i + i + 1].push_back(to + to);
                    GT[to + to].push_back(i + i + 1);
                }
            }
        }
        if (checkSAT()) {
            return true;
        }
    }
    return false;

    //    sort(all(order), [&](int l, int r) {
    //        return g[l].size() < g[r].size();
    //    });
}

void solve() {
    in(n);
    if (!n) {
        exit(0);
    }

    vector<pt> a[n];
    for (int i = 0; i < n; ++i) {
        in(m);
        a[i].resize(m);
        for (int j = 0; j < m; ++j) {
            a[i][j].x = nxt();
            a[i][j].y = nxt();
        }
    }
    //g.clear();
    g.assign(n, vector<int>());

    int edgesSize = 0;
    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            if (check(a[i], a[j])) {
                g[i].pb(j);
                g[j].pb(i);
                ++edgesSize;
                //cout << "(" << i << "," << j << ")";
            }
        }
    }
    if (edgesSize == 0) {
        cout << "1\n";
        return;
    }
    memset(used, 0, sizeof(used));
    if (check2()) {
        cout << "2\n";
        return;
    }
    if (check3()) {
        cout << "3\n";
        return;
    }
    cout << "4\n";
}

int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
#endif


//    cout << pow(1.5, 35) << endl;
//    gen();
    int test = 0;
    while (1) {
        ++test;
        //cout << test << endl;
        solve();
    }
    return 0;
}

